<?php
// Initialisation de la base de données SQLite
function initDatabase() {
    $db_file = __DIR__ . '/admin.db';
    
    try {
        $db = new PDO('sqlite:' . $db_file);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Création de la table des administrateurs si elle n'existe pas
        $db->exec('CREATE TABLE IF NOT EXISTS admins (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            username TEXT NOT NULL UNIQUE,
            password TEXT NOT NULL
        )');
        
        // Création de la table des gérants si elle n'existe pas
        $db->exec('CREATE TABLE IF NOT EXISTS managers (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL UNIQUE,
            folder_name TEXT NOT NULL UNIQUE,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )');
        
        // Vérifier si l'admin par défaut existe déjà
        $stmt = $db->prepare('SELECT COUNT(*) FROM admins WHERE username = ?');
        $stmt->execute(['admin']);
        $count = $stmt->fetchColumn();
        
        // Ajouter l'admin par défaut s'il n'existe pas
        if ($count == 0) {
            $stmt = $db->prepare('INSERT INTO admins (username, password) VALUES (?, ?)');
            $stmt->execute(['admin', password_hash('admin123', PASSWORD_DEFAULT)]);
        }
        
        return $db;
    } catch (PDOException $e) {
        die("Erreur de base de données: " . $e->getMessage());
    }
}

// Fonction pour obtenir une connexion à la base de données
function getDatabase() {
    static $db = null;
    if ($db === null) {
        $db = initDatabase();
    }
    return $db;
}
?>
