<?php
session_start();
require_once 'database.php';
require_once 'functions.php';

// Rediriger vers la page de connexion si l'utilisateur n'est pas connecté
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

$error = '';
$success = '';

// Vérifier si un ID d'association a été fourni
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: index.php');
    exit;
}

$associationId = (int)$_GET['id'];

// Fonction pour supprimer un répertoire et son contenu
function deleteDirectory($dir) {
    if (!is_dir($dir)) {
        return false;
    }
    
    $files = array_diff(scandir($dir), array('.', '..'));
    
    foreach ($files as $file) {
        $path = $dir . '/' . $file;
        
        if (is_dir($path)) {
            deleteDirectory($path);
        } else {
            unlink($path);
        }
    }
    
    return rmdir($dir);
}

// Connexion à la base de données SQLite
$db = new SQLite3('admin.db');

// Récupérer les informations de l'association
$stmt = $db->prepare('SELECT id, name, folder_name FROM managers WHERE id = :id');
$stmt->bindValue(':id', $associationId, SQLITE3_INTEGER);
$result = $stmt->execute();
$association = $result->fetchArray(SQLITE3_ASSOC);

if (!$association) {
    header('Location: index.php');
    exit;
}

// Traitement de la suppression
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
    // Supprimer l'association de la base de données
    $stmt = $db->prepare('DELETE FROM managers WHERE id = :id');
    $stmt->bindValue(':id', $associationId, SQLITE3_INTEGER);
    
    if ($stmt->execute()) {
        // Supprimer le dossier de l'association
        $associationPath = __DIR__ . '/' . $association['folder_name'];
        if (is_dir($associationPath)) {
            deleteDirectory($associationPath);
        }
        
        // Rediriger vers la page d'accueil avec un message de succès
        $_SESSION['flash_message'] = [
            'message' => 'L\'association "' . htmlspecialchars($association['name']) . '" a été supprimée avec succès.',
            'type' => 'success'
        ];
        
        header('Location: index.php');
        exit;
    } else {
        $error = 'Erreur lors de la suppression de l\'association.';
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supprimer une association</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Supprimer une association</h1>
            <div class="user-info">
                <span>Connecté en tant qu'administrateur</span>
                <a href="change_password.php" class="btn btn-primary">Changer mot de passe</a>
                <a href="logout.php" class="btn btn-logout">Déconnexion</a>
            </div>
        </header>
        
        <main>
            <section class="form-section">
                <div class="back-link">
                    <a href="index.php">&larr; Retour au portail</a>
                </div>
                
                <?php if (!empty($error)): ?>
                    <div class="alert alert-error"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <div class="confirmation-box">
                    <h2>Confirmation de suppression</h2>
                    <p class="warning-text">Êtes-vous sûr de vouloir supprimer l'association "<?php echo htmlspecialchars($association['name']); ?>" ?</p>
                    <p class="warning-text"><strong>Attention :</strong> Cette action est irréversible. Toutes les données associées à cette association seront définitivement supprimées.</p>
                    
                    <div class="confirmation-actions">
                        <form method="POST" action="delete_manager.php?id=<?php echo $associationId; ?>">
                            <input type="hidden" name="confirm_delete" value="1">
                            <button type="submit" class="btn btn-danger">Confirmer la suppression</button>
                        </form>
                        <a href="index.php" class="btn btn-secondary">Annuler</a>
                    </div>
                </div>
            </section>
        </main>
        
        <footer>
            <p>&copy; <?php echo date('Y'); ?> - Portail d'Administration</p>
        </footer>
    </div>
</body>
</html>
