/**
 * Gestionnaire unifié pour les actions de suppression
 * Ce script assure que les boutons de suppression fonctionnent correctement
 * dans tous les navigateurs et serveurs
 */

document.addEventListener('DOMContentLoaded', function() {
    // Gestionnaire pour les boutons de suppression standard
    document.querySelectorAll('.delete-item').forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const id = this.getAttribute('data-id');
            const type = this.getAttribute('data-type');
            const name = this.getAttribute('data-name');
            const formId = this.getAttribute('data-form-id') || 'deleteItemForm';
            
            // Message de confirmation personnalisé en fonction du type
            let confirmMessage = `هل أنت متأكد من حذف هذا العنصر؟`;
            if (type && name) {
                confirmMessage = `هل أنت متأكد من حذف ${type} "${name}"؟`;
            }
            
            if (confirm(confirmMessage)) {
                // Trouver ou créer le formulaire de suppression
                let form = document.getElementById(formId);
                
                if (!form) {
                    // Créer un formulaire si aucun n'existe
                    form = document.createElement('form');
                    form.id = formId;
                    form.method = 'POST';
                    form.style.display = 'none';
                    document.body.appendChild(form);
                }
                
                // Vider le formulaire des champs précédents
                form.innerHTML = '';
                
                // Ajouter les champs nécessaires
                const actionInput = document.createElement('input');
                actionInput.type = 'hidden';
                actionInput.name = 'action';
                actionInput.value = this.getAttribute('data-action') || 'delete';
                form.appendChild(actionInput);
                
                // Ajouter l'ID de l'élément à supprimer
                const idField = this.getAttribute('data-id-field') || `${type}_id`;
                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = idField;
                idInput.value = id;
                form.appendChild(idInput);
                
                // Soumettre le formulaire
                form.submit();
            }
        });
    });
    
    // Compatibilité avec les anciens boutons de suppression
    document.querySelectorAll('.delete-user').forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const id = this.getAttribute('data-id');
            const username = this.getAttribute('data-username');
            
            if (confirm(`هل أنت متأكد من حذف المستخدم "${username}"؟`)) {
                const form = document.getElementById('deleteUserForm');
                document.getElementById('delete_user_id').value = id;
                form.submit();
            }
        });
    });
    
    document.querySelectorAll('.delete-member').forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const id = this.getAttribute('data-id');
            const name = this.getAttribute('data-name');
            
            if (confirm(`هل أنت متأكد من حذف العضو "${name}"؟`)) {
                const form = document.getElementById('deleteMemberForm');
                document.getElementById('delete_member_id').value = id;
                form.submit();
            }
        });
    });
});
