$(document).ready(function () {
    // Sidebar toggle
    $('#sidebarCollapse').on('click', function () {
        $('#sidebar').toggleClass('active');
    });

    // Form validation
    $('form').on('submit', function(e) {
        let isValid = true;
        $(this).find('[required]').each(function() {
            if (!$(this).val()) {
                isValid = false;
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('الرجاء ملء جميع الحقول المطلوبة');
        }
    });

    // Dynamic data loading
    function loadData(url, target) {
        $.ajax({
            url: url,
            method: 'GET',
            success: function(response) {
                $(target).html(response);
            },
            error: function() {
                alert('حدث خطأ أثناء تحميل البيانات');
            }
        });
    }

    // Date picker initialization
    if ($.fn.datepicker) {
        $('.datepicker').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            language: 'ar',
            rtl: true
        });
    }

    // DataTable initialization
    if ($.fn.DataTable) {
        $('.datatable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
            },
            "order": [[ 0, "desc" ]],
            "responsive": true
        });
    }

    // Print functionality
    $('.print-btn').on('click', function() {
        window.print();
    });

    // Dynamic form submission
    $('.ajax-form').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const url = form.attr('action');
        const method = form.attr('method');
        const data = form.serialize();

        $.ajax({
            url: url,
            method: method,
            data: data,
            success: function(response) {
                if (response.success) {
                    alert('تمت العملية بنجاح');
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                } else {
                    alert(response.message || 'حدث خطأ أثناء المعالجة');
                }
            },
            error: function() {
                alert('حدث خطأ في الاتصال');
            }
        });
    });

    // File upload preview
    $('input[type="file"]').on('change', function() {
        const file = this.files[0];
        const reader = new FileReader();
        const preview = $(this).siblings('.file-preview');

        reader.onload = function(e) {
            preview.attr('src', e.target.result);
        }

        if (file) {
            reader.readAsDataURL(file);
        }
    });

    // Tooltip initialization
    $('[data-toggle="tooltip"]').tooltip();

    // Confirmation dialogs
    $('.confirm-action').on('click', function(e) {
        if (!confirm('هل أنت متأكد من هذا الإجراء؟')) {
            e.preventDefault();
        }
    });
});
