<?php
function get_print_header($title) {
    global $db;
    
    // Get association settings
    $stmt = $db->query("SELECT * FROM association_settings WHERE id = 1");
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
    
    ob_start();
    ?>
    <div class="print-header">
        <div class="d-flex justify-content-between align-items-center mb-4">
         
            <div class="logo">
                <img src="uploads/association_logo.png"  style="height: 80px;">
            </div>
           
            <div class="text-center flex-grow-1">
                <h3 class="mb-2"><?php echo htmlspecialchars($settings['name'] ?? ''); ?></h3>
                <?php if (!empty($settings['address'])): ?>
                <p class="mb-1"><?php echo htmlspecialchars($settings['address']); ?></p>
                <?php endif; ?>
                <?php if (!empty($settings['phone']) || !empty($settings['email'])): ?>
                <p class="mb-1">
                    <?php if (!empty($settings['phone'])): ?>
                    <span class="me-3">هاتف: <?php echo htmlspecialchars($settings['phone']); ?></span>
                    <?php endif; ?>
                    <?php if (!empty($settings['email'])): ?>
                    <span>البريد الإلكتروني: <?php echo htmlspecialchars($settings['email']); ?></span>
                    <?php endif; ?>
                </p>
                <?php endif; ?>
                <h4 class="mt-3"><?php echo htmlspecialchars($title); ?></h4>
            </div>
            <div class="logo-placeholder" style="width: 80px;"><!-- For alignment --></div>
        </div>
        <div class="print-date text-start mb-3">
            تاريخ الطباعة: <?php echo date('Y-m-d'); ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
?>
