<?php
require_once 'includes/buffer_helper.php';
require_once 'config/database.php';
require_once 'includes/auth.php';

$database = new Database();
$auth = new Auth($database);

// Redirect to login if not authenticated
if (!$auth->isLoggedIn() && basename($_SERVER['PHP_SELF']) !== 'login.php') {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام إدارة الجمعيات</title>
    <link rel="icon" type="image/x-icon" href="ficona.png">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <script src="assets/js/delete-handlers.js"></script>
</head>
<body>
    <?php if ($auth->isLoggedIn()): ?>
    <div class="wrapper">
        <?php if (!defined('HIDE_NAVBAR')): ?>
        <!-- Sidebar -->
        <nav id="sidebar" class="bg-dark text-light">
            <div class="sidebar-header">
                <h3>لوحة التحكم</h3>
            </div>

            <ul class="list-unstyled components">
                <li>
                    <a href="?page=dashboard"><i class="bi bi-house-door"></i> الرئيسية</a>
                </li>
                <?php if ($auth->hasPermission('president')): ?>
                <li>
                    <a href="?page=settings"><i class="bi bi-gear"></i> الإعدادات</a>
                </li>
                <li>
                    <a href="?page=members"><i class="bi bi-people"></i> الأعضاء</a>
                </li>
                <li>
                    <a href="?page=users"><i class="bi bi-person-gear"></i> المستخدمون</a>
                </li>
                <?php endif; ?>
                <?php if ($auth->hasPermission('treasurer')): ?>
                <li>
                    <a href="?page=finances"><i class="bi bi-cash"></i> المالية</a>
                </li>
                <li>
                    <a href="?page=bank_accounts"><i class="bi bi-bank"></i> الحسابات البنكية</a>
                </li>
                <li>
                    <a href="?page=cash_funds"><i class="bi bi-cash-stack"></i> الصناديق المالية</a>
                </li>
               
                <?php endif; ?>
                <li>
                    <a href="?page=activities"><i class="bi bi-calendar-event"></i> الأنشطة</a>
                </li>
                <li>
                    <a href="?page=print_activities"><i class="bi bi-printer"></i> طباعة الأنشطة</a>
                </li>
                <li>
                    <a href="?page=reports"><i class="bi bi-file-text"></i> التقارير</a>
                </li>
                <li>
                    <a href="?page=print_reports"><i class="bi bi-printer"></i> طباعة التقارير</a>
                </li>
                <li>
                    <a href="logout.php"><i class="bi bi-box-arrow-right"></i> تسجيل الخروج</a>
                </li>
            </ul>
        </nav>
        <?php endif; ?>
        <!-- Page Content -->
        <div id="content">
            <?php if (!defined('HIDE_NAVBAR')): ?>
            <nav class="navbar navbar-expand-lg navbar-light bg-light">
                <div class="container-fluid">
                    <button type="button" id="sidebarCollapse" class="btn btn-dark">
                        <i class="bi bi-list"></i>
                    </button>
                    <span class="navbar-text">
                        مرحباً <?php echo htmlspecialchars($_SESSION['username']); ?>
                        <button class="btn btn-sm btn-outline-secondary ms-2" data-bs-toggle="modal" data-bs-target="#changePasswordModal">
                            <i class="bi bi-key"></i> تغيير كلمة المرور
                        </button>
                    </span>
                </div>
            </nav>
            <?php endif; ?>
            <div class="container-fluid content-area">
                <?php
                $page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';
                $allowed_pages = [
                    'dashboard' => 'pages/dashboard.php',
                    'settings' => 'pages/settings.php',
                    'members' => 'pages/members.php',
                    'users' => 'pages/users.php',
                    'finances' => 'pages/finances.php',
                    'bank_accounts' => 'pages/bank_accounts.php',
                    'cash_funds' => 'pages/cash_funds.php',
                    'activities' => 'pages/activities.php',
                    'print_activities' => 'pages/print_activities.php',
                    'print_reports' => 'pages/print_reports.php',
                    'reports' => 'pages/reports.php',
                    'change_password' => 'pages/change_password.php',
                    'download_statement' => 'pages/download_statement.php'
                ];

                if (isset($allowed_pages[$page])) {
                    $page_path = $allowed_pages[$page];
                    if (file_exists($page_path)) {
                        include $page_path;
                    } else {
                        echo '<div class="alert alert-danger">الصفحة غير موجودة</div>';
                    }
                } else {
                    include 'pages/dashboard.php';
                }
                ?>
            </div>
        </div>
    </div>

    <!-- Change Password Modal -->
    <div class="modal fade" id="changePasswordModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">تغيير كلمة المرور</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="?page=change_password">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">كلمة المرور الحالية</label>
                            <input type="password" class="form-control" name="current_password" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">كلمة المرور الجديدة</label>
                            <input type="password" class="form-control" name="new_password" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">تأكيد كلمة المرور الجديدة</label>
                            <input type="password" class="form-control" name="confirm_password" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary">تغيير كلمة المرور</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php endif; ?>

    <script>
        $(document).ready(function() {
            // Toggle sidebar
            $('#sidebarCollapse').on('click', function() {
                $('#sidebar').toggleClass('active');
            });

            // Afficher les messages d'erreur ou de succès
            const urlParams = new URLSearchParams(window.location.search);
            const error = urlParams.get('error');
            const success = urlParams.get('success');

            if (error) {
                const alertDiv = $('<div class="alert alert-danger alert-dismissible fade show" role="alert">')
                    .text(decodeURIComponent(error))
                    .append('<button type="button" class="btn-close" data-bs-dismiss="alert"></button>');
                $('.content-area').prepend(alertDiv);
            }

            if (success) {
                const alertDiv = $('<div class="alert alert-success alert-dismissible fade show" role="alert">')
                    .text(decodeURIComponent(success))
                    .append('<button type="button" class="btn-close" data-bs-dismiss="alert"></button>');
                $('.content-area').prepend(alertDiv);
            }
        });
    </script>
    <script src="assets/js/main.js"></script>
</body>
</html>
