<?php
require_once 'config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    // Create admin user
    $admin_password = password_hash('admin123', PASSWORD_DEFAULT);
    $db->exec("INSERT OR IGNORE INTO users (username, password, role) VALUES ('admin', '$admin_password', 'president')");

    // Create default income categories
    $income_categories = [
        'انخراطات' => 'رسوم انخراط الأعضاء',
        'تبرعات' => 'تبرعات وهبات',
        'إعانات' => 'إعانات من المؤسسات',
        'أنشطة' => 'مداخيل الأنشطة',
        'شراكات' => 'اتفاقيات الشراكة'
    ];

    foreach ($income_categories as $name => $description) {
        $stmt = $db->prepare("INSERT OR IGNORE INTO income_categories (name, description) VALUES (?, ?)");
        $stmt->execute([$name, $description]);
    }

    // Create default expense categories
    $expense_categories = [
        'مصاريف إدارية' => 'مصاريف التسيير الإداري',
        'مصاريف الأنشطة' => 'نفقات تنظيم الأنشطة',
        'مصاريف الكهرباء' => 'فواتير الكهرباء',
        'مصاريف الماء' => 'فواتير الماء',
        'مصاريف الصيانة' => 'صيانة المقر والتجهيزات'
    ];

    foreach ($expense_categories as $name => $description) {
        $stmt = $db->prepare("INSERT OR IGNORE INTO expense_categories (name, description) VALUES (?, ?)");
        $stmt->execute([$name, $description]);
    }

    // Create default association settings
    $db->exec("INSERT OR IGNORE INTO association_settings (id, name, address) VALUES (1, 'الجمعية', 'العنوان')");

    echo "تم تهيئة قاعدة البيانات بنجاح!\n";
    echo "يمكنك الآن تسجيل الدخول باستخدام:\n";
    echo "اسم المستخدم: admin\n";
    echo "كلمة المرور: admin123\n";

} catch (PDOException $e) {
    die("خطأ في تهيئة قاعدة البيانات: " . $e->getMessage());
}
?>
