<?php
ob_start(); // Start output buffering
// Désactiver l'affichage de la barre de navigation pour cette page
define('HIDE_NAVBAR', true);

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/database.php';

$database = new Database();
$db = $database->getConnection();
$auth = new Auth($database);

// Get activities with optional filters
$where_conditions = [];
$params = [];

if (!empty($_GET['start_date'])) {
    $where_conditions[] = "date >= ?";
    $params[] = $_GET['start_date'];
}

if (!empty($_GET['end_date'])) {
    $where_conditions[] = "date <= ?";
    $params[] = $_GET['end_date'];
}

$where_clause = "";
if (!empty($where_conditions)) {
    $where_clause = "WHERE " . implode(" AND ", $where_conditions);
}

$stmt = $db->prepare("
    SELECT * FROM activities 
    $where_clause 
    ORDER BY date DESC, time DESC
");
$stmt->execute($params);
$activities = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get association settings
$stmt = $db->query("SELECT * FROM association_settings WHERE id = 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير الأنشطة</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            @page {
                size: A4;
                margin: 1.5cm;
            }
            body {
                font-size: 12pt;
                line-height: 1.3;
                background: none;
                margin: 0;
                padding: 0;
            }
            .no-print, .no-print * {
                display: none !important;
            }
            #wrapper, #content {
                margin: 0 !important;
                padding: 0 !important;
            }
            .navbar, .sidebar, #sidebarCollapse {
                display: none !important;
            }
            .page-header {
                margin-bottom: 20px;
                border-bottom: 1px solid #000;
                padding-bottom: 10px;
            }
            table {
                width: 100%;
                border-collapse: collapse;
                margin-bottom: 20px;
                page-break-inside: auto;
            }
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            th, td {
                padding: 8px;
                border: 1px solid #000;
            }
            th {
                background-color: #f8f9fa !important;
                font-weight: bold;
            }
            .table-striped tbody tr:nth-of-type(odd) {
                background-color: #f8f9fa !important;
            }
            .container-fluid {
                padding: 0 !important;
                margin: 0 !important;
                width: 100% !important;
            }
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .page-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .association-logo {
            max-width: 100px;
            height: auto;
            margin-bottom: 10px;
        }
        .filters {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .report-title {
            font-size: 24px;
            font-weight: bold;
            margin: 20px 0;
            text-align: center;
        }
        .report-subtitle {
            font-size: 16px;
            color: #666;
            margin-bottom: 20px;
            text-align: center;
        }
        .table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <!-- Filters -->
    <div class="container-fluid mb-4 no-print filters">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">من تاريخ</label>
                <input type="date" class="form-control" name="start_date" value="<?php echo $_GET['start_date'] ?? ''; ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">إلى تاريخ</label>
                <input type="date" class="form-control" name="end_date" value="<?php echo $_GET['end_date'] ?? ''; ?>">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary me-2">تصفية</button>
                <button type="button" class="btn btn-success" onclick="window.print()">طباعة</button>
            </div>
        </form>
    </div>

    <!-- Report Header -->
    <div class="container-fluid">
        <div class="page-header">
           
            <img src="uploads/association_logo.png" height="40px" alt="شعار الجمعية" class="association-logo">
           
            <h1><?php echo htmlspecialchars($settings['name'] ?? 'الجمعية'); ?></h1>
            <p><?php echo htmlspecialchars($settings['address'] ?? ''); ?></p>
            <p>الهاتف: <?php echo htmlspecialchars($settings['phone'] ?? ''); ?></p>
        </div>

        <div class="report-title">تقرير الأنشطة</div>
        <?php if (!empty($_GET['start_date']) || !empty($_GET['end_date'])): ?>
        <div class="report-subtitle">
            الفترة: 
            <?php echo !empty($_GET['start_date']) ? date('Y/m/d', strtotime($_GET['start_date'])) : 'البداية'; ?> 
            إلى 
            <?php echo !empty($_GET['end_date']) ? date('Y/m/d', strtotime($_GET['end_date'])) : 'النهاية'; ?>
        </div>
        <?php endif; ?>

        <!-- Activities Table -->
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width="5%">#</th>
                        <th width="20%">النشاط</th>
                        <th width="15%">التاريخ</th>
                        <th width="15%">الوقت</th>
                        <th width="20%">المكان</th>
                        <th>الوصف</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($activities as $index => $activity): ?>
                    <tr>
                        <td><?php echo $index + 1; ?></td>
                        <td><?php echo htmlspecialchars($activity['name']); ?></td>
                        <td><?php echo date('Y/m/d', strtotime($activity['date'])); ?></td>
                        <td><?php echo date('H:i', strtotime($activity['time'])); ?></td>
                        <td><?php echo htmlspecialchars($activity['location']); ?></td>
                        <td><?php echo htmlspecialchars($activity['description']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($activities)): ?>
                    <tr>
                        <td colspan="6" class="text-center">لا توجد أنشطة</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Report Footer -->
        <div class="text-start mt-4">
            <p>تاريخ الطباعة: <?php echo date('Y/m/d H:i'); ?></p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
